using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class STD_STATEDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public STD_STATEDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public STD_STATE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            STD_STATE objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_STATE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        //public List<STD_STATE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        //{
        //    List<STD_STATE> objReturn = null;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            objReturn = dbContext.usp_STD_STATE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        //public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_STATE objSave)
        //{
        //    Int32? objReturn = objSave.ID;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            dbContext.usp_STD_STATE_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COUNTRY_ID, objSave.CREATED, objSave.CREATEDBY, objSave.FIPSCODE, objSave.ID, objSave.NAME, objSave.POSTALNAME, objSave.UPDATED, objSave.UPDATEDBY);
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn.GetValueOrDefault();
        //}

        //public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        //{
        //    Boolean objReturn = false;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            dbContext.usp_STD_STATE_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
        //            objReturn = true;
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        #endregion
    }
}
